/*
 * Decompiled with CFR 0.152.
 */
package jftp;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class Jrftp {
    static int TRY_TIMES = 500;
    static int DOWNLOAD_TIMEOUT = 5000;
    static int TRY_TIMES_CONNECTION = 5000;
    static int TRY_TIMES_PASSIVE = 500;
    static int TRY_TIMES_BEFORE_BREAK = 500;
    static int TRY_TIMES_SUCCESS = 0;
    static int TRY_TIMES_BEFORE_BREAK_SUCCESS = 0;
    static int TRY_TIMES_PASSIVE_SUCCESS = 0;
    static int MAX_TRY_TIMES = 3000;
    static int MAX_TRY_TIMES_BEFORE_BREAK = 3000;
    static int MAX_TRY_TIMES_PASSIVE = 3000;
    static int MIN_TRY_TIMES = 150;
    static int MIN_TRY_TIMES_BEFORE_BREAK = 150;
    static int MIN_TRY_TIMES_PASSIVE = 150;
    static int SUCCES_COUNTER = 2;
    static int MIN_TIME_PERCENTAGE = 10;
    static int MAX_TIME_PERCENTAGE = 20;
    static int MAX_RECONNECTION_TIME_DELAY = 300000;
    static int TASK_OK_IDLE = 100;
    static int reconnection_time = 0;
    static int reconnection_time_less = 50;
    static int tries = 0;
    static String[] skips;
    static int nskips;
    static String CURRENT_OS;
    static SocketChannel socketPASV;
    static SocketChannel socketChannel;
    static String root_folder;
    static String remote_replace;

    public static int GetPassivePort(String dati) {
        boolean HH = false;
        boolean HL = false;
        int counter = 0;
        String HHS = "";
        String HLS = "";
        String the_response = "";
        for (int i = 0; i < dati.length(); ++i) {
            if (dati.charAt(i) == ',' || dati.charAt(i) == ')') {
                ++counter;
                continue;
            }
            if (counter == 4) {
                HHS = HHS + dati.charAt(i);
            }
            if (counter != 5) continue;
            HLS = HLS + dati.charAt(i);
        }
        if (counter < 5 || dati.length() == 0 || HHS.length() == 0 || HLS.length() == 0) {
            return -1;
        }
        return Integer.parseInt(HHS) * 256 + Integer.parseInt(HLS);
    }

    public static String send_command(String CMD) {
        try {
            int i;
            int bytesRead;
            if (TRY_TIMES_BEFORE_BREAK_SUCCESS > SUCCES_COUNTER) {
                TRY_TIMES_BEFORE_BREAK_SUCCESS = 0;
                if (TRY_TIMES_BEFORE_BREAK > MIN_TRY_TIMES_BEFORE_BREAK) {
                    TRY_TIMES_BEFORE_BREAK -= TRY_TIMES_BEFORE_BREAK * MIN_TIME_PERCENTAGE / 100;
                }
            }
            String the_message = "";
            ByteBuffer buf = ByteBuffer.allocate(10240);
            long readen = 0L;
            while ((bytesRead = socketChannel.read(buf)) > 0) {
                readen += (long)bytesRead;
                for (int i2 = 0; i2 < bytesRead; ++i2) {
                    the_message = the_message + (char)buf.get(i2);
                }
                buf.flip();
            }
            if (readen > 0L) {
                System.out.print("Response (" + readen + " bytes): " + the_message);
            }
            int opsuccess = 0;
            int last_char = 0;
            readen = 0L;
            the_message = "";
            int ttry = 0;
            System.out.println("SENDING COMMAND: " + CMD);
            ByteBuffer bufW = ByteBuffer.allocate(10240);
            bufW.clear();
            bufW.put(CMD.getBytes());
            bufW.flip();
            socketChannel.configureBlocking(true);
            while (bufW.hasRemaining()) {
                socketChannel.write(bufW);
            }
            socketChannel.configureBlocking(false);
            buf = ByteBuffer.allocate(10240);
            while (true) {
                if ((bytesRead = socketChannel.read(buf)) > 0) {
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                        last_char = (char)buf.get(i);
                        ++readen;
                    }
                    buf.flip();
                    ttry = 0;
                    Thread.sleep(1L);
                    if (opsuccess <= 1) continue;
                    ++opsuccess;
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= TRY_TIMES_BEFORE_BREAK) {
                    if (last_char == 10 && opsuccess == 0) {
                        ++opsuccess;
                        ttry = 0;
                        continue;
                    }
                    if (last_char == 10 && opsuccess > 0) {
                        if (opsuccess == 1) {
                            ++TRY_TIMES_BEFORE_BREAK_SUCCESS;
                            break;
                        }
                        TRY_TIMES_BEFORE_BREAK_SUCCESS = 0;
                        if (TRY_TIMES_BEFORE_BREAK >= MAX_TRY_TIMES_BEFORE_BREAK) break;
                        TRY_TIMES_BEFORE_BREAK += TRY_TIMES_BEFORE_BREAK * MAX_TIME_PERCENTAGE / 100;
                        break;
                    }
                }
                if (ttry >= TRY_TIMES_BEFORE_BREAK * 4) break;
            }
            if (readen == 0L) {
                ttry = 0;
                do {
                    Thread.sleep(1L);
                    ++ttry;
                    bytesRead = socketChannel.read(buf);
                    if (bytesRead <= 0) continue;
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                        last_char = (char)buf.get(i);
                        ++readen;
                    }
                    buf.flip();
                    ttry = 0;
                } while ((ttry < TRY_TIMES_BEFORE_BREAK || last_char != 10) && ttry < DOWNLOAD_TIMEOUT);
            }
            if (readen > 0L) {
                System.out.print("Reply (" + readen + " bytes): " + the_message);
            }
            return the_message;
        }
        catch (Exception e) {
            System.out.println("ERROR 1 " + e.getMessage());
            return "ERROR";
        }
    }

    public static String get_response_command() {
        try {
            int i;
            int bytesRead;
            if (TRY_TIMES_SUCCESS > SUCCES_COUNTER) {
                TRY_TIMES_SUCCESS = 0;
                if (TRY_TIMES > MIN_TRY_TIMES) {
                    TRY_TIMES -= TRY_TIMES * MIN_TIME_PERCENTAGE / 100;
                }
            }
            ++TRY_TIMES_SUCCESS;
            String the_message = "";
            boolean cursor = false;
            int ttry = 0;
            ByteBuffer buf = ByteBuffer.allocate(10240);
            long readen = 0L;
            while (true) {
                if ((bytesRead = socketChannel.read(buf)) > 0) {
                    readen += (long)bytesRead;
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                    }
                    buf.flip();
                    ttry = 0;
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= TRY_TIMES) break;
            }
            ttry = 0;
            while (true) {
                if ((bytesRead = socketChannel.read(buf)) > 0) {
                    readen += (long)bytesRead;
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                    }
                    buf.flip();
                    ttry = 0;
                    TRY_TIMES_SUCCESS = 0;
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= TRY_TIMES) break;
            }
            if (readen > 0L) {
                System.out.print("Response (" + readen + " bytes): " + the_message);
            }
            return the_message;
        }
        catch (Exception e) {
            System.out.println("ERROR 2 " + e.getMessage());
            return "ERROR";
        }
    }

    public static SocketChannel create_passive_socket(int port, String host) {
        try {
            int ttry = 0;
            System.out.println("Connecting to the FTP server on port " + port);
            if (socketPASV.isConnected()) {
                socketPASV.close();
            }
            if (socketPASV.isConnectionPending()) {
                socketPASV.close();
            }
            socketPASV = SocketChannel.open();
            socketPASV.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            socketPASV.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            socketPASV.configureBlocking(false);
            socketPASV.connect(new InetSocketAddress(host, port));
            while (!socketPASV.finishConnect()) {
                Thread.sleep(1L);
                if (++ttry <= TRY_TIMES_CONNECTION) continue;
            }
            if (socketPASV.isConnected()) {
                System.out.println("Connected!");
            }
            return socketPASV;
        }
        catch (Exception e) {
            System.out.println("ERROR 3 " + e.getMessage());
            return socketPASV;
        }
    }

    public static String get_passive_response() {
        try {
            int i;
            int bytesRead;
            String the_message = "";
            ByteBuffer buf = ByteBuffer.allocate(10240);
            long readen = 0L;
            while ((bytesRead = socketChannel.read(buf)) > 0) {
                readen += (long)bytesRead;
                for (int i2 = 0; i2 < bytesRead; ++i2) {
                    the_message = the_message + (char)buf.get(i2);
                }
                buf.flip();
            }
            if (readen > 0L) {
                System.out.print("Response (" + readen + " bytes): " + the_message);
            }
            boolean readen_error = false;
            if (TRY_TIMES_PASSIVE_SUCCESS > SUCCES_COUNTER) {
                TRY_TIMES_PASSIVE_SUCCESS = 0;
                if (TRY_TIMES_PASSIVE > MIN_TRY_TIMES_PASSIVE) {
                    TRY_TIMES_PASSIVE -= TRY_TIMES_BEFORE_BREAK * MIN_TIME_PERCENTAGE / 100;
                }
            }
            ++TRY_TIMES_PASSIVE_SUCCESS;
            the_message = "";
            boolean cursor = false;
            int ttry = 0;
            buf = ByteBuffer.allocate(10240);
            while (true) {
                if ((bytesRead = socketPASV.read(buf)) > 0) {
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                    }
                    buf.flip();
                    ttry = 0;
                    Thread.sleep(1L);
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= TRY_TIMES_PASSIVE) break;
            }
            ttry = 0;
            while (true) {
                if ((bytesRead = socketPASV.read(buf)) > 0) {
                    readen_error = true;
                    for (i = 0; i < bytesRead; ++i) {
                        the_message = the_message + (char)buf.get(i);
                    }
                    buf.flip();
                    ttry = 0;
                    Thread.sleep(1L);
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= TRY_TIMES_PASSIVE) break;
            }
            if (readen_error) {
                TRY_TIMES_PASSIVE_SUCCESS = 0;
                if (TRY_TIMES_PASSIVE < MAX_TRY_TIMES_PASSIVE) {
                    TRY_TIMES_PASSIVE += TRY_TIMES_PASSIVE * MAX_TIME_PERCENTAGE / 100;
                }
            }
            socketPASV.close();
            System.out.print(the_message);
            return the_message;
        }
        catch (Exception e) {
            System.out.println("ERROR 4 " + e.getMessage());
            return "ERROR";
        }
    }

    public static String connect_to_ftp(String host, String username, String password, int ServerPort) {
        try {
            TRY_TIMES = 500;
            TRY_TIMES_PASSIVE = 500;
            TRY_TIMES_BEFORE_BREAK = 500;
            TRY_TIMES_SUCCESS = 0;
            TRY_TIMES_BEFORE_BREAK_SUCCESS = 0;
            TRY_TIMES_PASSIVE_SUCCESS = 0;
            if (reconnection_time > 0) {
                System.out.println("Waiting  " + reconnection_time + " milliseconds before connecting ..");
            }
            if (tries > 0 && (reconnection_time += 5000) > 0) {
                Thread.sleep(reconnection_time);
            }
            if (reconnection_time > MAX_RECONNECTION_TIME_DELAY) {
                reconnection_time = 0;
            }
            ++tries;
            int ttry = 0;
            String newData = "";
            String reply = "";
            System.out.println("Connecting to the FTP server..");
            if (socketChannel.isConnectionPending()) {
                System.out.println("A connection is already pending..");
                socketChannel.close();
            }
            if (socketChannel.isConnected()) {
                socketChannel.close();
            }
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            socketChannel.connect(new InetSocketAddress(host, ServerPort));
            while (!socketChannel.finishConnect()) {
                Thread.sleep(1L);
                if (++ttry <= TRY_TIMES_CONNECTION) continue;
            }
            if (!socketChannel.isConnected()) {
                ttry = 0;
                while (!socketChannel.finishConnect()) {
                    Thread.sleep(1L);
                    if (++ttry <= TRY_TIMES_CONNECTION) continue;
                }
            }
            if (!socketChannel.isConnected()) {
                ttry = 0;
                while (!socketChannel.finishConnect()) {
                    Thread.sleep(1L);
                    if (++ttry <= TRY_TIMES_CONNECTION) continue;
                    System.out.println("FTP Connection Error!");
                    return "ERROR";
                }
            }
            System.out.println("Connected to the FTP server.. ");
            reply = Jrftp.get_response_command();
            newData = "USER " + username + "\r\n";
            reply = Jrftp.send_command(newData);
            newData = "PASS " + password + "\r\n";
            reply = Jrftp.send_command(newData);
            newData = "PWD\r\n";
            reply = Jrftp.send_command(newData);
            newData = "TYPE I\r\n";
            reply = Jrftp.send_command(newData);
            return "OK";
        }
        catch (Exception e) {
            System.out.println("ERROR 5 " + e.getMessage());
            return "ERROR";
        }
    }

    public static String download_file(String local_path, Long size) {
        try {
            int bytesRead;
            String the_message = "";
            ByteBuffer buf = ByteBuffer.allocate(10240);
            long readen = 0L;
            while ((bytesRead = socketChannel.read(buf)) > 0) {
                readen += (long)bytesRead;
                for (int i = 0; i < bytesRead; ++i) {
                    the_message = the_message + (char)buf.get(i);
                }
                buf.flip();
            }
            if (CURRENT_OS.startsWith("Windows")) {
                local_path = local_path.replace("/", "\\");
            }
            System.out.println("File Download start, size to download: " + size + " bytes");
            long total_size = 0L;
            boolean cursor = false;
            int ttry = 0;
            buf = ByteBuffer.allocate(900000);
            FileOutputStream fos = new FileOutputStream(local_path);
            byte[] buffer = new byte[900000];
            while (true) {
                if ((bytesRead = socketPASV.read(buf)) > 0) {
                    total_size += (long)bytesRead;
                    for (int i = 0; i < bytesRead; ++i) {
                        buffer[i] = buf.get(i);
                    }
                    fos.write(buffer, 0, bytesRead);
                    buf.flip();
                    ttry = 0;
                    continue;
                }
                Thread.sleep(1L);
                if (++ttry >= DOWNLOAD_TIMEOUT || size == total_size) break;
            }
            fos.close();
            socketPASV.close();
            System.out.println(local_path + " - (" + total_size + " bytes written)");
            if (reconnection_time > 0) {
                reconnection_time -= reconnection_time * MIN_TIME_PERCENTAGE / 100;
            }
            return "OK";
        }
        catch (Exception e) {
            System.out.println("ERROR 6" + e.getMessage());
            return "ERROR";
        }
    }

    public static String backup_data(String local_path, String remote_path, String host, String username, String password, int ServerPort) {
        try {
            String newData;
            String reply;
            File theDir;
            if (root_folder.length() == 0) {
                root_folder = local_path + remote_path;
                remote_replace = remote_path;
            }
            if (nskips > 0) {
                for (int i = 0; i < skips.length; ++i) {
                    if (skips[i].compareTo(remote_path) != 0) continue;
                    System.out.println("SKIP: " + remote_path);
                    return "OK";
                }
            }
            String directoryName = local_path + remote_path.replaceFirst(remote_replace, "");
            if (CURRENT_OS.startsWith("Windows")) {
                directoryName = directoryName.replace("/", "\\");
            }
            if (!(theDir = new File(directoryName)).exists()) {
                System.out.println("Creating local directory: " + directoryName);
                boolean result = theDir.mkdir();
                if (result) {
                    System.out.println("Local directory created: " + directoryName);
                }
            }
            if ((reply = Jrftp.send_command(newData = "PASV\r\n")) == "ERROR") {
                socketChannel.close();
                socketChannel = SocketChannel.open();
                while (!socketChannel.isConnected()) {
                    Jrftp.connect_to_ftp(host, username, password, ServerPort);
                }
                return "ERROR";
            }
            int port = Jrftp.GetPassivePort(reply);
            if (port == -1) {
                socketChannel.close();
                socketChannel = SocketChannel.open();
                return "ERROR";
            }
            socketPASV = Jrftp.create_passive_socket(port, host);
            if (!socketPASV.isConnected()) {
                return "ERROR";
            }
            newData = "MLSD " + remote_path + "\r\n";
            reply = Jrftp.send_command(newData);
            if (reply == "ERROR") {
                socketChannel.close();
                socketChannel = SocketChannel.open();
                return "ERROR";
            }
            String the_response = Jrftp.get_passive_response();
            String the_line = "";
            String type = "";
            String size = "";
            String modify = "";
            String file_dir = "";
            for (int i = 0; i < the_response.length(); ++i) {
                if (the_response.charAt(i) != '\n') {
                    int x;
                    if (the_response.charAt(i) != '\r' && the_response.charAt(i) != '\n') {
                        the_line = the_line + the_response.charAt(i);
                    }
                    if (the_response.charAt(i) != '\r' && the_response.charAt(i) != '\n' && (file_dir.length() != 0 || the_response.charAt(i) != ' ')) {
                        file_dir = file_dir + the_response.charAt(i);
                    }
                    if (the_response.charAt(i) == ';') {
                        file_dir = "";
                    }
                    if (the_response.charAt(i) != '=') continue;
                    if (i > 4 && the_response.charAt(i - 4) == 't' && the_response.charAt(i - 3) == 'y' && the_response.charAt(i - 2) == 'p' && the_response.charAt(i - 1) == 'e') {
                        for (x = i + 1; the_response.charAt(x) != ';' && x < the_response.length(); ++x) {
                            type = type + the_response.charAt(x);
                        }
                    }
                    if (i > 4 && the_response.charAt(i - 4) == 's' && the_response.charAt(i - 3) == 'i' && the_response.charAt(i - 2) == 'z' && the_response.charAt(i - 1) == 'e') {
                        for (x = i + 1; the_response.charAt(x) != ';' && x < the_response.length(); ++x) {
                            size = size + the_response.charAt(x);
                        }
                    }
                    if (i <= 4 || the_response.charAt(i - 6) != 'm' || the_response.charAt(i - 5) != 'o' || the_response.charAt(i - 4) != 'd' || the_response.charAt(i - 3) != 'i' || the_response.charAt(i - 2) != 'f' || the_response.charAt(i - 1) != 'y') continue;
                    for (x = i + 1; the_response.charAt(x) != ';' && x < the_response.length(); ++x) {
                        modify = modify + the_response.charAt(x);
                    }
                    continue;
                }
                if (type.equals("file")) {
                    File f;
                    if (nskips > 0) {
                        for (int x = 0; x < skips.length; ++x) {
                            if (skips[x].compareTo(remote_path + "/" + file_dir) != 0) continue;
                            type = "";
                            size = "";
                            modify = "";
                            the_line = "";
                            file_dir = "";
                        }
                    }
                    String File_Path = directoryName + "/" + file_dir;
                    if (CURRENT_OS.startsWith("Windows")) {
                        File_Path = directoryName + "\\" + file_dir;
                    }
                    if (!(f = new File(File_Path)).isFile() || f.length() != Long.parseLong(size)) {
                        newData = "PASV\r\n";
                        reply = Jrftp.send_command(newData);
                        if (reply == "ERROR") {
                            socketChannel.close();
                            socketChannel = SocketChannel.open();
                            return "ERROR";
                        }
                        port = Jrftp.GetPassivePort(reply);
                        if (port == -1) {
                            return "ERROR";
                        }
                        socketPASV = Jrftp.create_passive_socket(port, host);
                        newData = "RETR " + remote_path + "/" + file_dir + "\r\n";
                        reply = Jrftp.send_command(newData);
                        if (reply == "ERROR") {
                            socketChannel.close();
                            socketChannel = SocketChannel.open();
                            return "ERROR";
                        }
                        if (Jrftp.download_file(directoryName + "/" + file_dir, Long.parseLong(size)) == "ERROR") {
                            return "ERROR";
                        }
                        reply = Jrftp.get_response_command();
                        Thread.sleep(TASK_OK_IDLE);
                    } else {
                        System.out.println("Skip file " + directoryName + "/" + file_dir + " - Already Exist! ");
                    }
                }
                if (type.equals("dir")) {
                    while (Jrftp.backup_data(local_path, remote_path + "/" + file_dir, host, username, password, ServerPort) == "ERROR") {
                    }
                }
                type = "";
                size = "";
                modify = "";
                the_line = "";
                file_dir = "";
            }
            if (reconnection_time > 0) {
                reconnection_time -= reconnection_time * MIN_TIME_PERCENTAGE / 100;
            }
            return "OK";
        }
        catch (Exception e) {
            return "ERROR";
        }
    }

    public static void main(String[] args) {
        CURRENT_OS = System.getProperty("os.name").startsWith("Windows") ? "Windows" : "Linux";
        String bk_path = "";
        String destination_folder = "";
        String host = "";
        String username = "";
        String password = "";
        int port = 21;
        if (args.length < 4) {
            System.out.println("Parameters: local_path remote_path host username password [-p(optional) port] [-s(skip file or directory optional) directory1 directory2 file1 file2 ... file_N]");
            return;
        }
        bk_path = args[1];
        destination_folder = args[0];
        host = args[2];
        username = args[3];
        password = args[4];
        if (args.length > 4) {
            for (int s = 5; s < args.length; ++s) {
                if (args[s].compareTo("-p") == 0 || args[s].compareTo("-P") == 0) {
                    port = Integer.parseInt(args[++s]);
                    System.out.println("Server Port:" + port);
                }
                if (args[s].compareTo("-s") != 0 && args[s].compareTo("-S") != 0) continue;
                int numberofskip = args.length - ++s;
                System.out.println("Skip " + numberofskip + " files or directories:");
                skips = new String[args.length - s];
                nskips = args.length - s;
                for (int x = 0; x < numberofskip; ++x) {
                    Jrftp.skips[x] = args[s];
                    System.out.println(skips[x]);
                    ++s;
                }
            }
        }
        System.out.println("Backup operation destination folder: " + destination_folder + "\ntarget FTP folder: " + bk_path + "\nFtp server: " + host + ":" + port);
        try {
            socketPASV = SocketChannel.open();
            socketChannel = SocketChannel.open();
            File theDir = new File(destination_folder);
            if (!theDir.exists()) {
                System.out.println("Creating local directory: " + destination_folder);
                boolean result = theDir.mkdir();
                if (result) {
                    System.out.println("Local directory created " + destination_folder);
                }
            }
            while (!socketChannel.isConnected()) {
                Jrftp.connect_to_ftp(host, username, password, port);
            }
            while (Jrftp.backup_data(destination_folder, bk_path, host, username, password, port) == "ERROR") {
            }
            System.out.println("Backup completed, number connections: " + --tries);
        }
        catch (Exception e) {
            System.out.println("ERROR 8 " + e.getMessage());
        }
    }

    static {
        nskips = 0;
        CURRENT_OS = "";
        root_folder = "";
        remote_replace = "";
    }
}

